//
//  AccessControlList.h
//  Keychain
//
//  Created by Wade Tregaskis on Fri Jan 24 2003.
//  Copyright (c) 2003 Wade Tregaskis. All rights reserved.
//

#import "NSCachedObject.h"
#import <Foundation/Foundation.h>
#import <Security/Security.h>
//#import <Security/SecACL.h>
#import "TrustedApplication.h"


@interface AccessControlList : NSCachedObject {
    SecACLRef ACL;
    int error;
}

+ (AccessControlList*)accessControlListNamed:(NSString*)name fromAccessRef:(SecAccessRef)acc forApplications:(NSArray*)applications requiringPassphrase:(BOOL)reqPass;
+ (AccessControlList*)accessControlListWithACLRef:(SecACLRef)AC;

- (AccessControlList*)initWithName:(NSString*)name fromAccessRef:(SecAccessRef)acc forApplications:(NSArray*)applications requiringPassphrase:(BOOL)reqPass;
- (AccessControlList*)initWithACLRef:(SecACLRef)AC;

- (void)setApplications:(NSArray*)applications;
- (void)setName:(NSString*)name;
- (void)setRequiresPassphrase:(BOOL)reqPass;

- (NSArray*)applications;
- (NSString*)name;
- (BOOL)requiresPassphrase;

- (void)setAuthorizesAction:(CSSM_ACL_AUTHORIZATION_TAG)action to:(BOOL)value;
- (void)setAuthorizesEverything:(BOOL)value;
- (void)setAuthorizesLogin:(BOOL)value;
- (void)setAuthorizesGeneratingKeys:(BOOL)value;
- (void)setAuthorizesDeletion:(BOOL)value;
- (void)setAuthorizesExportingWrapped:(BOOL)value;
- (void)setAuthorizesExportingClear:(BOOL)value;
- (void)setAuthorizesImportingWrapped:(BOOL)value;
- (void)setAuthorizesImportingClear:(BOOL)value;
- (void)setAuthorizesSigning:(BOOL)value;
- (void)setAuthorizesEncrypting:(BOOL)value;
- (void)setAuthorizesDecrypting:(BOOL)value;
- (void)setAuthorizesMACGeneration:(BOOL)value;
- (void)setAuthorizesDerivingKeys:(BOOL)value;

- (BOOL)authorizesAction:(CSSM_ACL_AUTHORIZATION_TAG)action;
- (BOOL)authorizesEverything;
- (BOOL)authorizesLogin;
- (BOOL)authorizesGeneratingKeys;
- (BOOL)authorizesDeletion;
- (BOOL)authorizesExportingWrapped;
- (BOOL)authorizesExportingClear;
- (BOOL)authorizesImportingWrapped;
- (BOOL)authorizesImportingClear;
- (BOOL)authorizesSigning;
- (BOOL)authorizesEncrypting;
- (BOOL)authorizesDecrypting;
- (BOOL)authorizesMACGeneration;
- (BOOL)authorizesDerivingKeys;

- (void)deleteAccessControlList;

- (int)lastError;
- (SecACLRef)ACLRef;

@end
